import numpy as np
from gym import utils
from gym.envs.mujoco import mujoco_env
 
class StochasticAntEnv(mujoco_env.MujocoEnv, utils.EzPickle):
    def __init__(self):
        mujoco_env.MujocoEnv.__init__(self, 'ant.xml', 5)
        utils.EzPickle.__init__(self)

    def step(self, a):
        # a = a + np.random.normal(0, np.random.uniform(0.005, 0.05, a.shape))
        a = a + np.random.normal(0, 0.005 if np.random.sample() < 0.5 else 0.001)
        xposbefore = self.get_body_com("torso")[0]
        self.do_simulation(a, self.frame_skip)
        xposafter = self.get_body_com("torso")[0]
        forward_reward = (xposafter - xposbefore)/self.dt
        ctrl_cost = .5 * np.square(a).sum()
        contact_cost = 0.5 * 1e-3 * np.sum(
            np.square(np.clip(self.sim.data.cfrc_ext, -1, 1)))
        survive_reward = 1.0
        #reward_noise = np.random.normal(0, np.random.uniform(0, 1))
        reward = forward_reward - ctrl_cost - contact_cost + survive_reward# + reward_noise
        #print("-21", reward, reward - reward_noise)
        state = self.state_vector()
        notdone = np.isfinite(state).all() \
            and state[2] >= 0.2 and state[2] <= 1.0
        done = not notdone
        ori_ob = self._get_obs()
        # stochastic
        varmi = 0.001 # 绝对值最大值 高斯分布
        varma = 0.01
        # sto_ob = ori_ob + np.random.normal(0, var, ori_ob.shape)
        # sto_ob = ori_ob + np.random.normal(0, np.random.uniform(varmi, varma, ori_ob.shape))  # old
        sto_ob = ori_ob# + np.random.normal(0, 0.5 if np.random.sample() < 0.5 else 0.1)  
        # print("L31", np.mean(sto_ob - ori_ob))
        return sto_ob, reward, done, dict(
            reward_forward=forward_reward,
            reward_ctrl=-ctrl_cost,
            reward_contact=-contact_cost,
            reward_survive=survive_reward)

    def _get_obs(self):
        return np.concatenate([
            self.sim.data.qpos.flat[2:],
            self.sim.data.qvel.flat,
            np.clip(self.sim.data.cfrc_ext, -1, 1).flat,
        ])

    def reset_model(self):
        qpos = self.init_qpos + self.np_random.uniform(size=self.model.nq, low=-.1, high=.1)
        qvel = self.init_qvel + self.np_random.randn(self.model.nv) * .1
        self.set_state(qpos, qvel)
        return self._get_obs()

    def viewer_setup(self):
        self.viewer.cam.distance = self.model.stat.extent * 0.5
